﻿namespace Microsoft.Samples.PlanMyNight.Bing
{
    using System;
    using Microsoft.Samples.PlanMyNight.Entities;

    public interface IBingMapsService
    {
        string GetClientToken(string clientIPAddress, int tokenValidityDurationMinutes);

        BingCoordinate GeocodeAddress(ActivityAddress address, string token);

        PagingResult<Activity> SearchActivities(AdvancedSearchQuery searchCriteria, string token);

        // Runs a search using a free-text query and retuns both results and the parsed location
        Tuple<PagingResult<Activity>, ActivityAddress> SearchActivities(NaturalSearchQuery query, string token);
    }
}
